/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.drink;

import cloud.lemonslice.teastory.blockentity.DrinkMakerBlockEntity;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.block.BlockHelper;
import xueluoanping.teastory.block.NormalHorizontalBlock;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class DrinkMakerBlock
extends NormalHorizontalBlock
implements EntityBlock {
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    private boolean flag = false;
    private static final VoxelShape NORTH_LEFT = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 1.0, 15.0, 4.0, 14.0);
    private static final VoxelShape SOUTH_LEFT = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 1.0, 15.0, 4.0, 14.0);
    private static final VoxelShape WEST_LEFT = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 0.0, 14.0, 4.0, 15.0);
    private static final VoxelShape EAST_LEFT = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 1.0, 14.0, 4.0, 15.0);

    public DrinkMakerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(true)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{LEFT}));
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0.8f;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case NORTH: {
                    return NORTH_LEFT;
                }
                case SOUTH: {
                    return SOUTH_LEFT;
                }
                case EAST: {
                    return EAST_LEFT;
                }
            }
            return WEST_LEFT;
        }
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return SOUTH_LEFT;
            }
            case SOUTH: {
                return NORTH_LEFT;
            }
            case EAST: {
                return WEST_LEFT;
            }
        }
        return EAST_LEFT;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.m_5776_() && player.m_7500_()) {
            DrinkMakerBlock.removeBottomHalf(worldIn, pos, state, player);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        Direction facing;
        BlockPos blockPos;
        BlockState blockstate;
        if (!((Boolean)state.m_61143_((Property)LEFT)).booleanValue() && (blockstate = world.m_8055_(blockPos = pos.m_121945_(BlockHelper.getPreviousHorizontal(facing = (Direction)state.m_61143_((Property)f_54117_))))).m_60734_() == state.m_60734_() && ((Boolean)blockstate.m_61143_((Property)LEFT)).booleanValue()) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
            BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
            return blockstate.m_60783_((BlockGetter)worldIn, pos.m_7495_(), Direction.UP);
        }
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockPos = pos.m_121945_(BlockHelper.getPreviousHorizontal(facing));
        BlockState blockstate = worldIn.m_8055_(blockPos);
        return blockstate.m_60713_((Block)this);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)LEFT)).booleanValue()) {
            if (facing == BlockHelper.getNextHorizontal((Direction)stateIn.m_61143_((Property)f_54117_))) {
                return facingState.m_60734_() == this && (Boolean)facingState.m_61143_((Property)LEFT) == false ? stateIn : Blocks.f_50016_.m_49966_();
            }
        } else if (facing == BlockHelper.getPreviousHorizontal((Direction)stateIn.m_61143_((Property)f_54117_))) {
            return facingState.m_60734_() == this && (Boolean)facingState.m_61143_((Property)LEFT) != false ? stateIn : Blocks.f_50016_.m_49966_();
        }
        return stateIn;
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        super.m_6786_(level, pos, state);
        if (!level.m_5776_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
                serverLevel.m_46747_(pos);
            }
        }
    }

    public void m_6810_(BlockState pState, Level worldIn, BlockPos pos, BlockState pNewState, boolean isMoving) {
        if (!pNewState.m_60713_((Block)this)) {
            this.dropItems(worldIn, pos);
        }
        super.m_6810_(pState, worldIn, pos, pNewState, isMoving);
    }

    private void dropItems(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof DrinkMakerBlockEntity) {
            for (int i = 0; i < 11; ++i) {
                ItemStack stack = ((DrinkMakerBlockEntity)te).decrStackSize(i, Integer.MAX_VALUE);
                if (stack == ItemStack.f_41583_) continue;
                Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            this.flag = false;
            if (!((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
                pos = pos.m_121945_(BlockHelper.getPreviousHorizontal((Direction)state.m_61143_((Property)f_54117_)));
            }
            BlockEntity te = worldIn.m_7702_(pos);
            FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)player.m_21120_(handIn), (int)1)).ifPresent(item -> te.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_()).ifPresent(fluid -> {
                this.flag = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)fluid);
            }));
            if (this.flag) {
                return InteractionResult.SUCCESS;
            }
            if (te instanceof DrinkMakerBlockEntity) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)te), (BlockPos)te.m_58899_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState state1, boolean b) {
        if (!level.m_5776_() && ((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
            level.m_46597_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_()), (BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false)));
        }
        super.m_6807_(state, level, pos, state1, b);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)LEFT) != false ? new DrinkMakerBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldIn, BlockState state, BlockEntityType<T> blockEntityType) {
        return !worldIn.f_46443_ && (Boolean)state.m_61143_((Property)LEFT) != false ? NormalHorizontalBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityRegister.DRINK_MAKER_TYPE.get(), DrinkMakerBlockEntity::tick) : null;
    }
}

